﻿
using System.Linq;
using System.Windows.Forms;

namespace Validation.Input
{
    /// <summary>
    /// Handles the diffrent valdition for user input into the XML generation form. This ensures files written will work with the deserialization system inside Unity
    /// Author: Sam Scott
    /// </summary>
    static class InputValidation
    {

        public static bool CheckInputtedConditionIsValid(TextBox textBox)
        {
            bool isBool = bool.TryParse(textBox.Text, out bool boolVal);
            if (textBox.Text.Contains('>') || textBox.Text.Contains('<'))
            {
                string value = textBox.Text.Remove(0, 1);

                bool isWholeNumber = int.TryParse(value, out int number);
                bool isFloatingNumber = float.TryParse(value, out float floatNumber);
                if (isWholeNumber)
                {
                    return true;
                }
                else if (isFloatingNumber)
                {
                    return true;
                }

                else
                {
                    return false;
                }
            }


            else if (!isBool)
            {
                return false;
            }
            else { return true; }
        }

        public static bool CheckInputedKeyIsValid(TextBox textBox)
        {
            if (System.Text.RegularExpressions.Regex.IsMatch(textBox.Text, "[^0-9]"))
            {
                MessageBox.Show("Please enter only numbers.");
                textBox.Text = textBox.Text.Remove(textBox.Text.Length - 1);
                return false;
            }

            else
            { return true; }
        }

    }

    
}
