﻿using System;
using System.Xml.Linq;
using System.Collections.Generic;
using System.IO;
using System.Windows.Forms;

/// <summary>
/// Static class that allows for an XML file to be created based on user entered values, as well as file name and directory to save the created xml file to
/// Author: Sam Scott
/// </summary>
namespace File_Utility
{
    public static class FileHandler
    {
        // static XElement keys;
        static XElement lines;

        //  static XElement conditions;
        public static void CreateXmlFile(string id, string name, List<LineData> linesData, string fileName, string directory, string root)
        {

            int lineNumber = 1;
            int conditionNumber = 1;

            lines = new XElement("Lines");

            foreach (var line in linesData)
            {



                XElement xLine = new XElement("Line",
                new XAttribute("id", line.lineID.ToString()), new XElement("Key", line.key), new XElement("LineText", line.lineText));

                XElement xConditions = new XElement("Conditions");


                foreach (var condition in line.lineConditionsDictionary.Values)
                {

                    XElement xCondition = new XElement("Condition", new XAttribute("id", condition.designerKey));
                    xCondition.Add(new XElement("TriggerCondition", condition.lineCondition));
                    xCondition.Add(new XElement("GameDataName", condition.gameDataName), new XElement("GameDataKey", condition.gameDataKey));
                    xConditions.Add(xCondition);
                    conditionNumber++;
                }

                conditionNumber = 1;

                Console.WriteLine(xLine);
                xLine.Add(xConditions);
                lines.Add(xLine);
                lineNumber++;
            }

            XDocument xmlFile = new XDocument(
               new XDeclaration("1.0", "utf-8", "yes"),
               new XElement(root, //root
                   new XAttribute("ID", id),
                   new XAttribute("Name", name), lines ) );


            //Try catch saving to file incase file access is denied (XMLLINQ AUTO OVERWRITES WIHOUT EXCEPTION, so just check if user has access to where they are saving)
            try
            {
                xmlFile.Save(directory + "/" + fileName + ".xml");
            }
            catch (UnauthorizedAccessException)
            {
                FileAttributes attr = (new FileInfo(directory + "/" + fileName + ".xml")).Attributes;
                MessageBox.Show("Un-authorised file access! Anti-virus / windows defender may be blocking saving access. Please ensure this application is a trusted developer and has full permissions and is not blocked by firewall/anti-virus");
                if ((attr & FileAttributes.ReadOnly) > 0)
                    Console.Write("The file is read-only.");
            }

        }


        /// <summary>
        /// Deserialzie an XML file using the file path provided 
        /// </summary>
        /// <param name="path"></param>
        /// <returns></returns>
        public static List<LineData> LoadXMLFile(string path, out NPCData npcDataToSet)
        {

            List<LineData> lineDataList = new List<LineData>();
            NPCData npcData = new NPCData();


            XDocument xDoc = XDocument.Load(path);

            //Get the root of the file
            var npc = xDoc.Root;

            //Set the npc data from file (not dialogue just npc id and name!)
            npcData.npcID = uint.Parse(npc.Attribute("ID").Value);
            npcData.npcName = npc.Attribute("Name").Value;

            //Out-put the npc id and name to set in the form fields
            npcDataToSet = npcData;

            var line = xDoc.Root.Descendants("Line"); //Get all nodes called line




            int i = 1;

            foreach (var lineNode in line)
            {

                LineData lineObj = new LineData();
                lineObj.lineConditionsDictionary = new Dictionary<uint, LineConditionData>();


                var key = lineNode.Descendants("Key");
                var _line = lineNode.Descendants("LineText"); //Try use this as iterator to make it not 6
                var conditions = lineNode.Descendants("Condition");

                lineObj.lineID = uint.Parse((string)lineNode.Attribute("id").Value);

                foreach (var _key in key)
                {
                    ///   Debug.Log("Line Key: " + _key.Value);
                    lineObj.key = _key.Value;
                }

                foreach (var nodeLine in _line)
                {
                    //  Debug.Log("Line: " + nodeLine.Value);
                    lineObj.lineText = nodeLine.Value;
                }

                foreach (var condition in conditions)
                {
                    LineConditionData conditionData = new LineConditionData();

                    var gameDataName = condition.Descendants("GameDataName");
                    foreach (var _gameDataLine in gameDataName)
                    {
                        conditionData.gameDataName = _gameDataLine.Value;
                    }

                    var gameDataKey = condition.Descendants("GameDataKey");
                    foreach (var _gameDataKeyLine in gameDataKey)
                    {
                        conditionData.gameDataKey = uint.Parse(_gameDataKeyLine.Value);
                    }
                    var triggerCondition = condition.Descendants("TriggerCondition");
                    foreach (var _triggerConditionLine in triggerCondition)
                    {
                        conditionData.lineCondition = _triggerConditionLine.Value;

                    }

                    conditionData.designerKey = uint.Parse(condition.Attribute("id").Value);

                    lineObj.lineConditionsDictionary.Add(uint.Parse(condition.Attribute("id").Value), conditionData);

                    i++;
                }


                //Pass the populated line object to the lines to the line list within the entity object
                lineDataList.Add(lineObj);

            }

            return lineDataList;

        }



    }
}